;original java code by Nat Sarkissian -> http://www.openprocessing.org/sketch/6641
#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <GUIConstantsEx.au3>
#include <GDIPlus.au3>

_GDIPlus_Startup()

Global Const $iW = 1200, $iH = 800, $iRecursionLevel = 7, $iBranching = 3, $iRecursionDepth = $iBranching^($iRecursionLevel - ($iBranching - 3)) - 1, $iBGColor = 0xF8F8F8
Global Const $sTitle = "GDI+ Recursive Bush converted to AutoIt by UEZ / "
Global Const $hGUI = GUICreate($sTitle & "0 %", $iW, $iH)
GUISetState()

Global Const $hGfxHwnd = _GDIPlus_GraphicsCreateFromHWND($hGUI)
Global Const $hBitmap = _GDIPlus_BitmapCreateFromGraphics($iW, $iH, $hGfxHwnd)
Global Const $hGfxCtxt = _GDIPlus_ImageGetGraphicsContext($hBitmap)
Global Const $hPen = _GDIPlus_PenCreate(0xF03D1F1C), $hPen2 = _GDIPlus_PenCreate(0x80084808), $hBrush = _GDIPlus_BrushCreateSolid()
Global $hMatrix, $iRL = 0, $bDone = False

_GDIPlus_GraphicsSetSmoothingMode($hGfxCtxt, $GDIP_SMOOTHINGMODE_ANTIALIAS8X4 + (@OSBuild > 5999))

Draw()
$bDone = True

HotKeySet("{F10}", "Save_Bitmap")

Do
	Switch GUIGetMsg()
		Case $GUI_EVENT_PRIMARYUP
			$bDone = False
			Draw()
			$bDone = True
		Case $GUI_EVENT_CLOSE
			ExitLoop
	EndSwitch
Until False

_GDIPlus_PenDispose($hPen)
_GDIPlus_PenDispose($hPen2)
_GDIPlus_BrushDispose($hBrush)
_GDIPlus_GraphicsDispose($hGfxCtxt)
_GDIPlus_GraphicsDispose($hGfxHwnd)
_GDIPlus_BitmapDispose($hBitmap)
_GDIPlus_Shutdown()
GUIDelete()
Exit

Func Save_Bitmap()
	If $bDone And WinActive($hGUI) Then
		Local $sFilename = @ScriptDir & "\Bush_" & @YEAR & @MON & @MDAY & "_" & @HOUR & @MIN & @SEC & ".png"
		If _GDIPlus_ImageSaveToFile($hBitmap, $sFilename) Then MsgBox(64, "Information", "Bitmap saved to " & $sFilename)
	EndIf
EndFunc

Func Draw()
	Local $iMouseCursor = MouseGetCursor ()
	GUISetCursor(15, 1, $hGUI)
	Local $te, $t = TimerInit()
	$iRL = 0
	$hMatrix = _GDIPlus_MatrixCreate()
	_GDIPlus_GraphicsClear($hGfxCtxt, 0xFF000000 + $iBGColor)
	_GDIPlus_MatrixTranslate($hMatrix, $iW / 2, $iH)
	_GDIPlus_MatrixRotate($hMatrix, Random(-22.5, 0)) ; -$PI/8
	_GDIPlus_GraphicsSetTransform($hGfxCtxt, $hMatrix)
	Recursive_Bush($iH / 6, $iRecursionLevel)
	_GDIPlus_MatrixRotate($hMatrix, Random(0, 45)) ;0, $PI/4
	_GDIPlus_GraphicsSetTransform($hGfxCtxt, $hMatrix)
	Recursive_Bush($iH / 6, $iRecursionLevel)
	_GDIPlus_GraphicsDrawImageRect($hGfxHwnd, $hBitmap, 0, 0, $iW, $iH)
	_GDIPlus_MatrixDispose($hMatrix)
	$te = Round(TimerDiff($t), 2)
	ConsoleWrite($iRL & @CRLF)
	GUISetCursor($iMouseCursor, 1, $hGUI)
	_GDIPlus_GraphicsDrawString($hGfxHwnd, "Click lmb to create new bush! F10 to save image!", 4, $iH - 18)
	_GDIPlus_GraphicsDrawString($hGfxHwnd, "Bush created in " & $te & " ms.", 4, 4)
	WinSetTitle($hGUI, "", $sTitle & "100.00 %")
	ConsoleWrite("Runtime: " & $te & " ms." & @CRLF)
EndFunc

Func Recursive_Bush($h, $iLevel)
	Local Const $c = Random(50, 100, 1)
	DllCall($__g_hGDIPDll, "int", "GdipSetPenColor", "handle", $hPen, "dword", 0xFF000000 + 0x10000 * $c + $c / 3);generate stem / branch color
	DllCall($__g_hGDIPDll, "int", "GdipSetPenWidth", "handle", $hPen, "float", $iLevel)
	DllCall($__g_hGDIPDll, "int", "GdipDrawLine", "handle", $hGfxCtxt, "handle", $hPen, "float", 0, "float", 0, "float", 0, "float", -$h - 1) ;draw stem / branch
	Local $r, $t, $hMatrix_Clone, $fW, $fH
	If $iLevel > 0 Then
		$iLevel -= 1
		$iRL += 1
		If Not Mod($iRL, 250) Then WinSetTitle($hGUI, "", $sTitle & StringFormat("%.2f %", $iRL / $iRecursionDepth * 100)) ;update progress
		For $t = 0 To $iBranching - 1
			$hMatrix_Clone = DllCall($__g_hGDIPDll, "int", "GdipCloneMatrix", "handle", $hMatrix, "handle*", 0)[2]
			DllCall($__g_hGDIPDll, "int", "GdipTranslateMatrix", "handle", $hMatrix, "float", 0, "float", -$h, "int", False)
			DllCall($__g_hGDIPDll, "int", "GdipRotateMatrix", "handle", $hMatrix, "float", Random(-22.5, 22.5), "int", False) ;-PI/8,PI/8
			DllCall($__g_hGDIPDll, "int", "GdipSetWorldTransform", "handle", $hGfxCtxt, "handle", $hMatrix)
			Recursive_Bush($h * Random(0.45, 1), $iLevel)
			DllCall($__g_hGDIPDll, "int", "GdipDeleteMatrix", "handle", $hMatrix)
			$hMatrix = $hMatrix_Clone
		Next
	Else
		If Random(0, 1) > 0.25 Then ;create leafs
			$hMatrix_Clone = DllCall($__g_hGDIPDll, "int", "GdipCloneMatrix", "handle", $hMatrix, "handle*", 0)[2]
			DllCall($__g_hGDIPDll, "int", "GdipTranslateMatrix", "handle", $hMatrix, "float", 0, "float", -$h, "int", False)
			DllCall($__g_hGDIPDll, "int", "GdipRotateMatrix", "handle", $hMatrix, "float", Random(-22.5, 22.5), "int", False)
			DllCall($__g_hGDIPDll, "int", "GdipSetWorldTransform", "handle", $hGfxCtxt, "handle", $hMatrix)
			DllCall($__g_hGDIPDll, "int", "GdipSetSolidFillColor", "handle", $hBrush, "dword", 0xE0360000 + 0x100 * (Int(0x69 * Random(0.5, 1.25))) + 0x26) ;0xE0366926
			$fW = Random(0.7, 1.3) * Random(3, 12)
			$fH = Random(0.7, 1.3) * Random(3, 12)
			Switch Random(0, 5, 1)
				Case 0 To 3
					DllCall($__g_hGDIPDll, "int", "GdipFillEllipse", "handle", $hGfxCtxt, "handle", $hBrush, "float", 0, "float", 0, "float", $fW, "float", $fH)
					DllCall($__g_hGDIPDll, "int", "GdipDrawEllipse", "handle", $hGfxCtxt, "handle", $hPen2, "float", 0, "float", 0, "float", $fW, "float", $fH)
				Case Else
					DllCall($__g_hGDIPDll, "int", "GdipFillRectangle", "handle", $hGfxCtxt, "handle", $hBrush, "float", 0, "float", 0, "float", $fW, "float", $fH)
					DllCall($__g_hGDIPDll, "int", "GdipDrawRectangle", "handle", $hGfxCtxt, "handle", $hPen2, "float", 0, "float", 0, "float", $fW, "float", $fH)
			EndSwitch
			DllCall($__g_hGDIPDll, "int", "GdipDeleteMatrix", "handle", $hMatrix)
			$hMatrix = $hMatrix_Clone
		EndIf
	EndIf
;~ 	_GDIPlus_GraphicsDrawImageRect($hGfxHwnd, $hBitmap, 0, 0, $iW, $iH)
EndFunc